// dyncppexam1.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

#include "minimscdyn.h"

// NOTE: specify your file location
static char* libfilename = "w:\\minim\\minimsc\\minimsc.dll";

mnmcreateconnect_t MNMCreateConnect = NULL;
mnmdestroyconnect_t MNMDestroyConnect = NULL;
mnmconnectopen_t MNMConnectOpen = NULL;
mnmconnectclose_t MNMConnectClose = NULL;
mnmgetlasterror_t MNMGetLastError = NULL;
mnmread_t MNMRead = NULL;
mnmwrite_t MNMWrite = NULL;
mnmexecute_t MNMExecute = NULL;
mnmkill_t MNMKill = NULL;
mnmsetoutput_t MNMSetOutput = NULL;
mnmexecuteoutput_t MNMExecuteOutput = NULL;
mnmsetgroupread_t MNMSetGroupRead = NULL;
mnmsetcallback_t MNMSetCallback = NULL;
mnmlistget_t MNMListGet = NULL;
mnmlistset_t MNMListSet = NULL;
mnmlistlength_t MNMListLength = NULL;
mnmtext_t MNMText = NULL;

HMODULE hModule = NULL;

static void FreeMNMSC( void)
{
	if( hModule)
	{
		FreeLibrary( hModule);
		hModule = NULL;
	}
	MNMCreateConnect = NULL;
	MNMDestroyConnect = NULL;
	MNMConnectOpen = NULL;
	MNMConnectClose = NULL;
	MNMGetLastError = NULL;
	MNMRead = NULL;
	MNMWrite = NULL;
	MNMExecute = NULL;
	MNMKill = NULL;
	MNMSetOutput = NULL;
	MNMExecuteOutput = NULL;
	MNMSetGroupRead = NULL;
	MNMSetCallback = NULL;
	MNMListGet = NULL;
	MNMListSet = NULL;
	MNMListLength = NULL;
	MNMText = NULL;
	return;
};

static int LoadMNMSC( char* filename)
{
	if( hModule)
	{
		return 1;
	}
	hModule = LoadLibrary( filename);
	if( !hModule)
	{
		return 0;
	}

#define LOADFUNC( name, type) name = (type)GetProcAddress( hModule, #name); \
	if( !name) \
	{ \
		FreeMNMSC(); \
		return 0; \
	}

	LOADFUNC( MNMCreateConnect, mnmcreateconnect_t);
	LOADFUNC( MNMDestroyConnect, mnmdestroyconnect_t);
	LOADFUNC( MNMConnectOpen, mnmconnectopen_t);
	LOADFUNC( MNMConnectClose, mnmconnectclose_t);
	LOADFUNC( MNMGetLastError, mnmgetlasterror_t);
	LOADFUNC( MNMRead, mnmread_t);
	LOADFUNC( MNMWrite, mnmwrite_t);
	LOADFUNC( MNMExecute, mnmexecute_t);
	LOADFUNC( MNMKill, mnmkill_t);
	LOADFUNC( MNMSetOutput, mnmsetoutput_t);
	LOADFUNC( MNMExecuteOutput, mnmexecuteoutput_t);
	LOADFUNC( MNMSetGroupRead, mnmsetgroupread_t);
	LOADFUNC( MNMSetCallback, mnmsetcallback_t);
	LOADFUNC( MNMListGet, mnmlistget_t);
	LOADFUNC( MNMListSet, mnmlistset_t);
	LOADFUNC( MNMListLength, mnmlistlength_t);
	LOADFUNC( MNMText, mnmtext_t);

	return 1;
};

void HandleMNMError( HMNMConnect Connect)
{
  MINIMSTR err;
  MNMGetLastError( Connect, &err);
  printf( "MiniM error:\n%.*s\n", err.len, err.data);
  return;
};

static void DoExample1( void)
{
  printf( "\n---------\nExample 1\n");

  // create connect to MiniM
  HMNMConnect Connect = MNMCreateConnect( "localhost", 5000, "user");

  // activate connection
  int ret = MNMConnectOpen( Connect);
  if( !ret)
  {
    HandleMNMError( Connect);
    return;
  }

  // read version info
  MINIMSTR expr;
  MINIMSTR value;
  expr.len = sprintf( (char*)expr.data, "$zversion");
  ret = MNMRead( Connect, &expr, &value);
  if( !ret)
  {
    HandleMNMError( Connect);
    return;
  }

  // print result
  printf( "MiniM version: %.*s\n", value.len, value.data);

  // execute commands
  expr.len = sprintf( (char*)expr.data, "s a=123,b=456");
  ret = MNMExecute( Connect, &expr);
  if( !ret)
  {
    HandleMNMError( Connect);
    return;
  }

  // read 2 variables as list
  expr.len = sprintf( (char*)expr.data, "$lb(a,b)");
  ret = MNMRead( Connect, &expr, &value);
  if( !ret)
  {
    HandleMNMError( Connect);
    return;
  }

  // get list length
  int ListLength = MNMListLength( &value);
  printf( "List length: %d\n", ListLength);

  // unpack list structure
  MINIMSTR element;
  MNMListGet( &value, 1, &element);

  // show value
  printf( "First list item is: %.*s\n", element.len, element.data);

  MNMListGet( &value, 2, &element);
  
  printf( "Second list item is: %.*s\n", element.len, element.data);

  // disconnect from MiniM
  MNMConnectClose( Connect);

  // remove connect
  MNMDestroyConnect( Connect);
  
  return;
};

void __stdcall OutputProc( HMNMConnect pConnect, MINIMSTR* Value )
{
  printf( "%.*s", Value->len, Value->data);
  return;
};

static void DoExample2( void)
{
  printf( "\n---------\nExample 2\n");

  // create connect to MiniM
  HMNMConnect Connect = MNMCreateConnect( "localhost", 5000, "user");

  // activate connection
  int ret = MNMConnectOpen( Connect);
  if( !ret)
  {
    HandleMNMError( Connect);
    return;
  }

  // set output notifier function
  MNMSetOutput( Connect, OutputProc);

  printf( "MiniM database list:\n");

  MINIMSTR Commands;
  Commands.len = sprintf( (char*)Commands.data, "%s",
    "s list=$v(\"db\",15) f i=1:1:$l(list,\"*\") w $p(list,\"*\",i),!");

  // execute code to get database list
  MNMExecuteOutput( Connect, &Commands);

  // disconnect from MiniM
  MNMConnectClose( Connect);

  // remove connect
  MNMDestroyConnect( Connect);

  return;
};

int _tmain(int argc, _TCHAR* argv[])
{
	if( !LoadMNMSC( libfilename))
	{
		printf( "Failed to load %s\n", libfilename);
	}
	else
	{
		printf( "%s loaded ok\n", libfilename);

		DoExample1();

		DoExample2();

		FreeMNMSC();
	}

	printf( "\nDynamic loading example done, press any key\n");
	getch();
	return 0;
}

