/*

	Declarations for dynamic loading minimsc.dll

	Copyright (C) Eugene Karataev

*/

#ifndef __MINIMSCDYN_H__
#define __MINIMSCDYN_H__

#ifdef __cplusplus
extern "C" {
#endif

// type definitions if minimsc.h does not included
#ifndef MINIMSTR_MAX

/* max string size */
#define MINIMSTR_MAX ( 32 * 1024 )

#pragma pack(push,1)
typedef struct _MINIMSTR
{
  unsigned short len;
  unsigned char data[ MINIMSTR_MAX];
} MINIMSTR;
#pragma pack(pop)

typedef void* HMNMConnect;

#endif

/* create connect object */
// HMNMConnect MNMSCPROC MNMCreateConnect( char* server,
//   int port, char* database);
typedef HMNMConnect (__stdcall * mnmcreateconnect_t)( char* server, 
	int port, char* database);

/* destroy connect object */
// void MNMSCPROC MNMDestroyConnect( HMNMConnect pConnect);
typedef void (__stdcall * mnmdestroyconnect_t)( HMNMConnect pConnect);

/* connect to MiniM server */
// int MNMSCPROC MNMConnectOpen( HMNMConnect pConnect);
typedef int (__stdcall * mnmconnectopen_t)( HMNMConnect pConnect);

/* disconnect from MiniM server */
// int MNMSCPROC MNMConnectClose( HMNMConnect pConnect);
typedef int (__stdcall * mnmconnectclose_t)( HMNMConnect pConnect);

/* get last error description */
// void MNMSCPROC MNMGetLastError( HMNMConnect pConnect, MINIMSTR* pError);
typedef void (__stdcall * mnmgetlasterror_t)( HMNMConnect pConnect, MINIMSTR* pError);

/* read M expression */
// int MNMSCPROC MNMRead( HMNMConnect pConnect, MINIMSTR* Expression,
//   MINIMSTR* Result);
typedef int (__stdcall * mnmread_t)( HMNMConnect pConnect, MINIMSTR* Expression,
  MINIMSTR* Result);

/* write M variable */
// int MNMSCPROC MNMWrite( HMNMConnect pConnect, MINIMSTR* VarName,
  // MINIMSTR* VarValue);
typedef int (__stdcall * mnmwrite_t)( HMNMConnect pConnect, MINIMSTR* VarName,
  MINIMSTR* VarValue);

/* execute commands */
// int MNMSCPROC MNMExecute( HMNMConnect pConnect, MINIMSTR* Commands);
typedef int (__stdcall * mnmexecute_t)( HMNMConnect pConnect, MINIMSTR* Commands);

/* kill variable */
// int MNMSCPROC MNMKill( HMNMConnect pConnect, MINIMSTR* VarName);
typedef int (__stdcall * mnmkill_t)( HMNMConnect pConnect, MINIMSTR* VarName);

/* type of procedure to intercept output */
typedef void ( __stdcall* mnmoutputproc_t )( HMNMConnect pConnect,
  MINIMSTR* Value );

/* set procedure to intercept output */
// void MNMSCPROC MNMSetOutput( HMNMConnect pConnect, mnmoutputproc_t pProc);
typedef void (__stdcall * mnmsetoutput_t)( HMNMConnect pConnect, mnmoutputproc_t pProc);

/* execute commands with output interception */
// int MNMSCPROC MNMExecuteOutput( HMNMConnect pConnect, MINIMSTR* Commands);
typedef int (__stdcall * mnmexecuteoutput_t)( HMNMConnect pConnect, MINIMSTR* Commands);

/* type of procedure to accept group read data */
typedef void ( __stdcall* mnmgroupreadproc_t)( HMNMConnect pConnect,
  MINIMSTR* Value);

// void MNMSCPROC MNMSetGroupRead( HMNMConnect pConnect, mnmgroupreadproc_t pProc);
typedef void (__stdcall * mnmsetgroupread_t)( HMNMConnect pConnect, mnmgroupreadproc_t pProc);

/* type of procedure ho handle callback call */
typedef void ( __stdcall* mnmcallbackproc_t)( HMNMConnect pConnect,
  MINIMSTR* Command, MINIMSTR* Answer);

// void MNMSCPROC MNMSetCallback( HMNMConnect pConnect,
  // mnmcallbackproc_t pProc);
typedef void (__stdcall * mnmsetcallback_t)( HMNMConnect pConnect,
  mnmcallbackproc_t pProc);

/* get list element as $listget(list,pos) */
// int MNMSCPROC MNMListGet( MINIMSTR* List, int pos, MINIMSTR* Element);
typedef int (__stdcall * mnmlistget_t)( MINIMSTR* List, int pos, MINIMSTR* Element);

/* set list element as s $list(list,pos)=element */
// int MNMSCPROC MNMListSet( MINIMSTR* List, int pos, MINIMSTR* Element);
typedef int (__stdcall * mnmlistset_t)( MINIMSTR* List, int pos, MINIMSTR* Element);

/* return count of list elements */
// int MNMSCPROC MNMListLength( MINIMSTR* List);
typedef int (__stdcall * mnmlistlength_t)( MINIMSTR* List);

/* decorate '"' if need */
// int MNMSCPROC MNMText( MINIMSTR* Source, MINIMSTR* Target);
typedef int (__stdcall * mnmtext_t)( MINIMSTR* Source, MINIMSTR* Target);

#ifdef __cplusplus
}
#endif

#endif