'// dyncppexam1.bas : Defines the entry point for the console application.
'//
#define UNICODE
#include once "windows.bi"
#include once "minimscdyn.bi"

'// NOTE: specify your file location
'static char* libfilename = "w:\\minim\\minimsc\\minimsc.dll";
dim libfilename as zstring * 256  = "minimsc.dll"

dim shared MNMCreateConnect as mnmcreateconnect_t 
dim shared MNMDestroyConnect as mnmdestroyconnect_t 
dim shared MNMConnectOpen as mnmconnectopen_t 
dim shared MNMConnectClose as mnmconnectclose_t 
dim shared MNMGetLastError as mnmgetlasterror_t 
dim shared MNMRead as mnmread_t 
dim shared MNMWrite as mnmwrite_t 
dim shared MNMExecute as mnmexecute_t 
dim shared MNMKill as mnmkill_t 
dim shared MNMSetOutput as mnmsetoutput_t 
dim shared MNMExecuteOutput as mnmexecuteoutput_t 
dim shared MNMSetGroupRead as mnmsetgroupread_t 
dim shared MNMSetCallback as mnmsetcallback_t 
dim shared MNMListGet as mnmlistget_t 
dim shared MNMListSet as mnmlistset_t 
dim shared MNMListLength as mnmlistlength_t 
dim shared MNMText as mnmtext_t 

dim shared hLib as HMODULE 

sub FreeMNMSC()
	if hLib then
		FreeLibrary( hLib)
		hLib = NULL
	end if
	MNMCreateConnect = NULL
	MNMDestroyConnect = NULL
	MNMConnectOpen = NULL
	MNMConnectClose = NULL
	MNMGetLastError = NULL
	MNMRead = NULL
	MNMWrite = NULL
	MNMExecute = NULL
	MNMKill = NULL
	MNMSetOutput = NULL
	MNMExecuteOutput = NULL
	MNMSetGroupRead = NULL
	MNMSetCallback = NULL
	MNMListGet = NULL
	MNMListSet = NULL
	MNMListLength = NULL
	MNMText = NULL
end sub

function LoadMNMSC( byref zfilename as ZSTRING ) as integer
	if hLib then return 1
	hLib = LoadLibrary( zfilename)
	if hLib = 0 then return 0

   MNMCreateConnect = cast(mnmcreateconnect_t, GetProcAddress(hLib, "MNMCreateConnect"))
   if MNMCreateConnect = NULL then print "GetProcAddress error MNMCreateConnect": return 0

   MNMDestroyConnect = cast(mnmdestroyconnect_t, GetProcAddress(hLib, "MNMDestroyConnect"))
   if MNMDestroyConnect = NULL then print "GetProcAddress error MNMDestroyConnect": return 0

   MNMConnectOpen = cast(mnmconnectopen_t, GetProcAddress(hLib, "MNMConnectOpen"))
   if MNMConnectOpen = NULL then print "GetProcAddress error MNMConnectOpen": return 0

   MNMConnectClose = cast(mnmconnectclose_t, GetProcAddress(hLib, "MNMConnectClose"))
   if MNMConnectClose = NULL then print "GetProcAddress error MNMConnectClose": return 0

   MNMGetLastError = cast(mnmgetlasterror_t, GetProcAddress(hLib, "MNMGetLastError"))
   if MNMGetLastError = NULL then print "GetProcAddress error MNMGetLastError": return 0

   MNMRead = cast(mnmread_t, GetProcAddress(hLib, "MNMRead"))
   if MNMRead = NULL then print "GetProcAddress error MNMRead": return 0

   MNMWrite = cast(mnmwrite_t, GetProcAddress(hLib, "MNMWrite"))
   if MNMWrite = NULL then print "GetProcAddress error MNMWrite": return 0

   MNMExecute = cast(mnmexecute_t, GetProcAddress(hLib, "MNMExecute"))
   if MNMExecute = NULL then print "GetProcAddress error MNMExecute": return 0

   MNMKill = cast(mnmkill_t, GetProcAddress(hLib, "MNMKill"))
   if MNMKill = NULL then print "GetProcAddress error MNMKill": return 0

   MNMSetOutput = cast(mnmsetoutput_t, GetProcAddress(hLib, "MNMSetOutput"))
   if MNMSetOutput = NULL then print "GetProcAddress error MNMSetOutput": return 0

   MNMExecuteOutput = cast(mnmexecuteoutput_t, GetProcAddress(hLib, "MNMExecuteOutput"))
   if MNMExecuteOutput = NULL then print "GetProcAddress error MNMExecuteOutput": return 0

   MNMSetGroupRead = cast(mnmsetgroupread_t, GetProcAddress(hLib, "MNMSetGroupRead"))
   if MNMSetGroupRead = NULL then print "GetProcAddress error MNMSetGroupRead": return 0

   MNMSetCallback = cast(mnmsetcallback_t, GetProcAddress(hLib, "MNMSetCallback"))
   if MNMSetCallback = NULL then print "GetProcAddress error MNMSetCallback": return 0

   MNMListGet = cast(mnmlistget_t, GetProcAddress(hLib, "MNMListGet"))
   if MNMListGet = NULL then print "GetProcAddress error MNMListGet": return 0

   MNMListSet = cast(mnmlistset_t, GetProcAddress(hLib, "MNMListSet"))
   if MNMListSet = NULL then print "GetProcAddress error MNMListSet": return 0

   MNMListLength = cast(mnmlistlength_t, GetProcAddress(hLib, "MNMListLength"))
   if MNMListLength = NULL then print "GetProcAddress error MNMListLength": return 0

   MNMText = cast(mnmtext_t, GetProcAddress(hLib, "MNMText"))
   if MNMText = NULL then print "GetProcAddress error MNMText": return 0

	return 1
end function

sub HandleMNMError( byval Connect as HMNMConnect )
  dim t_err as MINIMSTR
  MNMGetLastError( Connect, @t_err)
  print "MiniM error: "; t_err.len, t_err.data
end sub


sub DoExample1()
  print "---------"
  print "Example 1"

  '// create connect to MiniM
  dim Connect as HMNMConnect = MNMCreateConnect( "localhost", 5000, "user")

  '// activate connection
  dim ret as integer = MNMConnectOpen( Connect)
  if ret = 0 then
    HandleMNMError( Connect)
    exit sub
  end if

  '// read version info
  dim expr as MINIMSTR
  dim zvalue as MINIMSTR 
  expr.data = "$zversion"
  expr.len = len(expr.data)
  ret = MNMRead( Connect, @expr, @zvalue)
  if ret = 0 then
    HandleMNMError( Connect): exit sub
  end if

  '// print result
  print "MiniM version: "; zvalue.data

  '// execute commands
  expr.data = "s a=123,b=456"
  expr.len = len(expr.data)
  ret = MNMExecute( Connect, @expr)
  if ret = 0 then
    HandleMNMError( Connect): exit sub
  end if

  '// read 2 variables as list
  expr.data = "$lb(a,b)"
  expr.len = len(expr.data)
  ret = MNMRead( Connect, @expr, @zvalue)
  if ret = 0 then
    HandleMNMError( Connect): exit sub
  end if

  '// get list length
  dim ListLength as integer = MNMListLength( @zvalue)
  print "List length: "; ListLength

  '// unpack list structure
  dim element as MINIMSTR 
  MNMListGet( @zvalue, 1, @element)

  '// show value
  print "First list item is: "; element.data

  MNMListGet( @zvalue, 2, @element)
  print "Second list item is: "; element.data
  
  '// disconnect from MiniM
  MNMConnectClose( Connect)

  '// remove connect
  MNMDestroyConnect( Connect)
  
end sub


'//
'//  MAIN PROGRAM ENTRY POINT
'//
if LoadMNMSC( libfilename ) = 0 then
   print "Failed to load ", libfilename
else
   print libfilename; " loaded ok"

   DoExample1()

   FreeMNMSC()
end if

print "Dynamic loading example done, press any key"
sleep

