'_________________________________________________________________
' Add: 2022-May-07
Type tsave_clrs
    
    fg As COLORREF
    bg As COLORREF
    
End Type

Dim Shared save_clrs As tsave_clrs
' ______________________________________________________________________________________
'
Function init_tabs() As Integer
    
    With frmTabSearch.lvEntryType
     
        .Font = New wfxFont( "Arial Narrow", 10, FontStyles.Normal, FontCharset.Ansi )
        .Items.Clear
        '' The time of the subject entry.
        .Columns.Add( "Date",     65, TextAlignment.Center )
        '' Move the header title a bit in this left justified column.
        .Columns.Add( Space(5) + "Entry",   155, TextAlignment.Left   )
        '' Set OddRowColor
        .OddRowColorEnabled = False
        .GridLines = True
     
        ListView_SetBkColor(.hWindow, Colors.DimGray)
     
    End With
    
    Function = 0
End Function
' ______________________________________________________________________________________
' Add: 2022-Apr-18 @ 10:33:01
Function frmTabSearch_lvEntryType_Click( ByRef sender As wfxListView, ByRef e As EventArgs ) As LRESULT

    If sender.Items.Count <= 0 Then Beep : Return 0

    Dim as long Row, Col
    Var HitTest = sender.HitTest( Row, Col )
    
    If HitTest = -1 Then
     
        session_log(Debug.prn( "HitTest Failed.", LCase(__FUNCTION__), __FILE__, GetLastError(), __LINE__, 0.00, 0, False), log_listbox)
        Return 0
     
    End If

    '' Variable to hold the text in Col 0 (date)
    Dim As String s = sender.Item(Row).SubItem(0).Text    
    
    '' Get the dateserial of the User selected entry
    Dim as Long l = to_dateserial_string_date(s)    

    '' Highlight the selected day in the Calendar Control
    frmTabSearch.mcJournal.SelectedDate = Format( l, "yyyymmdd")
    'Dim As Long y = GetLastError()
    '? y, __FUNCTION__    
    Function = move_rec_pointer(l)

    ' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
    ' Add: 2022-Jun-14
    ' Variable to hold the text in Col 1 (time)
    Dim As String sTime = sender.Item(Row).SubItem(1).Text
    ' Clean up sTime as we previously used to ToolTip the string
    ' using a CRLF to show the time of the entry.
    ' Extracts a String Time in 24hr format.
    sTime = RTrim(sTime, "]")
    sTime = Right(sTime, 5)
    '' Highlight the selected entry.
    If Not highlight_entry(frmMainJ.lvJournal, sTime) Then Messagebox(sender.hWindow, "TimeSlot Not Found: " + sTime, "Error", MB_OK)

End Function
' ______________________________________________________________________________________
' Add: 2022-Apr-18 @ 10:34:11
Function frmTabSearch_lvEntryType_MouseMove( ByRef sender As wfxListView, ByRef e As EventArgs ) As LRESULT

    ' Set tooltiptext.
    Dim as long Row, Col
    Var HT = sender.HitTest(Row, Col)

    If HT = -1 Then
     
        sender.ToolTip = ""
        Return 0
     
    End If

    ' Simplifies reading the listview for the User.
    Dim newTip As WString * 500 
    newTip = sender.Item(Row).SubItem(1).Text
    
    If Row = -1 Then newTip = "-"
    sender.ToolTip = newTip

    Function = 0

End Function
' ______________________________________________________________________________________
' Add: 2022-Apr-18 @ 12:39:23
Function frmTabSearch_txtJsearch_GotFocus( ByRef sender As wfxTextBox, ByRef e As EventArgs ) As LRESULT

    '' Clear the textbox if the user has not entered any text.
    If sender.Text = "Search for..." Then sender.Text = ""

    Function = 0

End Function
' ______________________________________________________________________________________
' Add: 2022-Apr-18 @ 12:57:01
Function frmTabSearch_btnSearchString_Click( ByRef sender As wfxButton, ByRef e As EventArgs ) As LRESULT

    If Len( frmTabSearch.txtJsearch.Text ) < 3 Or _
       Trim( frmTabSearch.txtJsearch.Text ) = "Search for..." Then 
       
       frmMainJ.StatusBar.Panel(5).Text = "Invalid search string"
       MessageBeep( MB_OK )
       Return 0
     
    End If
    
    '' Set this variable to string_search
    jdb.search_field = STRING_SEARCH
    '' This pretty much acts as a global variable.
    jdb.string_search = UCase( frmTabSearch.txtJsearch.Text )

    '' Highlight Rows of the ListView
    do_colour_search_results( frmMainj.lvJournal, jdb.string_search, __FUNCTION__ )
    '' 
    find_entries()
    '' Clear the last message
    frmMainJ.StatusBar.Panel(5).Text = "Search: " + UCase( frmTabSearch.txtJsearch.Text )

    Function = 0

End Function
' ______________________________________________________________________________________
' Add: 2022-Apr-18 @ 12:58:28
Function frmTabSearch_cboEventTypeSelector_Click( ByRef sender As wfxComboBox, ByRef e As EventArgs ) As LRESULT

    jdb.search_field = TYPCAT_SEARCH

    '' ComboBox is Sorted so we need to get the Index from the Class
    '' Variable to hold the Event_Type Index
    Dim As UByte ubIndex = jdb.Entry_Modifier( sender.SelectedItem.Text )
    
    '' Highlight Rows of the ListView
    do_colour_event_types( frmMainj.lvJournal, ubIndex, __FUNCTION__ )
    
    '' Rebuild the event type ListView
    '' displays results
    find_entries( ubIndex )

    Function = 0

End Function
' ______________________________________________________________________________________
' Add: 2022-Apr-18 @ 12:59:10
Function frmTabSearch_cboID_Click( ByRef sender As wfxComboBox, ByRef e As EventArgs ) As LRESULT


    jdb.search_field = ID_SEARCH
    
    Dim As UByte ubIndex = cdb.Get_ID( crms(), sender.SelectedItem.Text )
    '' Highlight Rows of the ListView
    do_colour_event_IDs( frmMainj.lvJournal, ubIndex, __FUNCTION__ )
    
    '' Rebuild the event type ListView
    '' displays results
    find_entries( ubIndex )
    
    Function = 0
End Function
' ______________________________________________________________________________________
' Add: 2022-Apr-18 @ 13:00:23
Function frmTabSearch_btnListOverdueEntries_Click( ByRef sender As wfxButton, ByRef e As EventArgs ) As LRESULT

    Dim As Boolean boo = find_overdue_entry_types(frmTabSearch.lvEntryType)
    ? "Function: "; __FUNCTION__; " Returned: " ; boo
    
    Function = 0

End Function
' ______________________________________________________________________________________
' Add: 2022-Apr-18 @ 13:01:29
Function frmTabSearch_btnListBlanks_Click( ByRef sender As wfxButton, ByRef e As EventArgs ) As LRESULT
    
    Dim As Boolean boo = find_blank_Entry_Type(frmTabSearch.lvEntryType)
    ? "Function: "; __FUNCTION__; " Returned: " ; boo
    
    Function = 0

End Function
' ______________________________________________________________________________________
' Add: 2022-Apr-19 @ 17:22:28
Function frmTabSearch_mcJournal_Click( ByRef sender As wfxMonthCalendar, ByRef e As EventArgs ) As LRESULT
    '' Create a DateSerial using the Calendar control structure.
    '' User clicked a valid date.
    Dim struc As SYSTEMTIME '' Structure     
    
    MonthCal_GetCurSel( sender.hWindow, @struc )
    '' Returns a DateSerial from the selected calendar date.
    Dim As Long l = DateSerial( struc.wYear, struc.wMonth, struc.wDay )
    'Dim As Long y = GetLastError()
    '? y, __FUNCTION__    
    '' move_rec_pointer. Creates a Daily Journal Dai if one does not exist.
    Function = move_rec_pointer( l )

End Function
' ______________________________________________________________________________________
' Add: 2022-May-05 @ 11:47:47
Function frmTabSearch_lvJournalDays_Click( ByRef sender As wfxListView, ByRef e As EventArgs ) As LRESULT

    Dim as long Row, Col
    Var HT = sender.HitTest(Row, Col)

    If HT = -1 Then
     
        Return 0
     
    End If

    '' Variable to hold the selected index
    Dim As Integer i = sender.SelectedIndex 
    '' String Variable to hold the long date
    Dim As String s = Left( sender.Item(i).Text, 10 )
    '' Returns the dateserial of the selected entry
    Dim as Long l = to_dateserial_string_date(s) 
    '' Highlight the selected day in the Calendar Control
    frmTabSearch.mcJournal.SelectedDate = Format( l, "yyyymmdd")
    'Dim As Long y = GetLastError()
    '? y, __FUNCTION__    
    Function = move_rec_pointer( l, __FUNCTION__ ) '' We only process part of the function

End Function
' ______________________________________________________________________________________
'
Function frmTabSearch_lvJournalDays_MouseMove( ByRef sender As wfxListView, ByRef e As EventArgs ) As LRESULT
    'sender.Item().BackColor = Colors.DimGray
    Dim as long Row, Col
    Var HT = sender.HitTest(Row, Col)

    If HT = -1 Then
        
        sender.ToolTip = ""
        Return 0
     
    End If

    ' Simplifies reading the listview for the User.
    Dim newTip As WString * 500 
    newTip = sender.Item(Row).SubItem(0).Text + " (Row=" + Str(Row) + ")"
    
    If Row = -1 Then newTip = "-"
    sender.ToolTip = newTip

    Function = 0

End Function
' ______________________________________________________________________________________
'
Function frmTabSearch_cboID_MouseDown( ByRef sender As wfxComboBox, ByRef e As EventArgs ) As LRESULT

    ' Add: 2022-Jun-22 @ 12:39:59
    ' Populate client ID combo only when needed.
    pop_id_combo( frmTabSearch.cboID, __FUNCTION__ + " - cboID search combo")
    
    Function = 0

End Function
''
''
Function frmTabSearch_lvEntryType_Click( ByRef sender As wfxListView, ByRef e As EventArgs ) As LRESULT
    Function = 0
End Function

''
''
Function frmTabSearch_lvEntryType_Click( ByRef sender As wfxListView, ByRef e As EventArgs ) As LRESULT
    Function = 0
End Function

